package jamezo97.clonecraft.item;

import jamezo97.clonecraft.CloneCraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemEmptyEgg extends Item{

	public Icon inside;
	
	public ItemEmptyEgg(int par1) {
		super(par1);
		setMaxStackSize(16);
	}

	@Override
	public void registerIcons(IconRegister ir) {
		super.registerIcons(ir);
		inside = ir.registerIcon("CloneCraft:spawnEggIn");
		((ItemSpawnEgg)CloneCraft.spawnEgg).setIcons(itemIcon, inside);
	}
	
	
	@Override
	public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
		return 0xffdfce9b;
	}

	@Override
	public boolean requiresMultipleRenderPasses() {
		return true;
	}

	@Override
	public Icon getIcon(ItemStack stack, int pass) {
		if(pass == 1){
			return inside;
		}
		return itemIcon;
	}
	
	
	

}
